/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class FlashCard
extends JPanel
implements ActionListener {
    protected int MAX_OPTIONS = 1;
    protected int MAX_WORDS = 20;
    protected String DEF_FILE = "words.1500.txt";
    protected String DEF_FILTER = "";
    protected ArrayList wordList;
    protected ArrayList currentMeaningList;
    protected boolean[] visited;
    protected int totalVisited;
    protected int currentHigherWordPointer;
    protected int currentLowerWordPointer;
    protected int total;
    protected int correct;
    protected JScrollPane scrollPane;
    protected JTextArea textArea;
    protected JButton checkButton;
    protected JButton nextButton;
    protected JButton resetButton;
    protected JPanel buttonPanel;
    protected JRadioButton[] radioButton;
    protected ButtonGroup radioButtonGroup;
    protected JPanel radioPanel;
    protected StatusPanel status;
    protected JLabel maxOptionsLabel;
    protected JTextField maxOptions;
    protected JLabel maxWordsLabel;
    protected JTextField maxWords;
    protected JPanel optionsPanel;
    protected JTextField fileName;
    protected JLabel fileNameLabel;
    protected JTextField filter;
    protected JLabel filterLabel;

    public FlashCard() {
        this.init();
    }

    protected void init() {
        this.initPanel();
        this.initComponents();
        this.addComponents();
        this.loadFile();
        this.reset();
        this.startSequence();
    }

    protected void initPanel() {
        this.setLayout(new GridBagLayout());
    }

    protected void initComponents() {
        this.maxOptionsLabel = new JLabel("Max Options:");
        this.maxOptions = new JTextField(this.MAX_OPTIONS + "");
        this.maxOptions.setActionCommand("Max Options");
        this.maxOptions.setColumns(5);
        this.maxOptions.addActionListener(this);
        this.maxWordsLabel = new JLabel("Max Words:");
        this.maxWords = new JTextField(this.MAX_WORDS + "");
        this.maxWords.setActionCommand("Max Words");
        this.maxWords.setColumns(5);
        this.maxWords.addActionListener(this);
        this.fileNameLabel = new JLabel("File Name:");
        this.fileName = new JTextField(this.MAX_WORDS + "");
        this.fileName.setActionCommand("File Name");
        this.fileName.setText(this.DEF_FILE);
        this.fileName.addActionListener(this);
        this.filterLabel = new JLabel("Filter:");
        this.filter = new JTextField(this.DEF_FILTER + "");
        this.filter.setActionCommand("Filter");
        this.filter.addActionListener(this);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.radioPanel = new JPanel();
        this.radioPanel.setLayout(new GridBagLayout());
        this.resetRadioPanel();
        this.checkButton = new JButton("Check");
        this.checkButton.addActionListener(this);
        this.nextButton = new JButton("Next");
        this.nextButton.addActionListener(this);
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(this);
        this.optionsPanel = new JPanel();
        this.optionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        this.optionsPanel.add((Component)this.fileNameLabel, gridBagConstraints);
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.gridx = 1;
        this.optionsPanel.add((Component)this.fileName, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        this.optionsPanel.add((Component)this.maxWordsLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 3;
        this.optionsPanel.add((Component)this.maxWords, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        this.optionsPanel.add((Component)this.filterLabel, gridBagConstraints);
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.gridx = 1;
        this.optionsPanel.add((Component)this.filter, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        this.optionsPanel.add((Component)this.maxOptionsLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 3;
        this.optionsPanel.add((Component)this.maxOptions, gridBagConstraints);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        this.buttonPanel.add((Component)this.checkButton, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        this.buttonPanel.add((Component)this.nextButton, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        this.buttonPanel.add((Component)this.resetButton, gridBagConstraints);
        this.status = new StatusPanel();
        this.status.updateStatus("Welcome");
    }

    protected void addComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.optionsPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.scrollPane, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.radioPanel, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.status, gridBagConstraints);
    }

    protected void resetRadioPanel() {
        this.radioPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.radioButtonGroup = new ButtonGroup();
        this.radioButton = new JRadioButton[this.MAX_OPTIONS];
        int n = 0;
        while (n < this.radioButton.length) {
            this.radioButton[n] = new JRadioButton(n + 1 + "");
            this.radioButtonGroup.add(this.radioButton[n]);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            this.radioPanel.add((Component)this.radioButton[n], gridBagConstraints);
            ++n;
        }
        this.radioPanel.repaint();
    }

    protected void reset() {
        this.visited = new boolean[this.wordList == null ? 0 : this.wordList.size()];
        this.totalVisited = 0;
        this.resetFilter();
        this.correct = 0;
        this.total = 0;
    }

    protected void resetFilter() {
        String string = this.filter.getText().trim().toLowerCase();
        if (string.equals("") || string.equals("*")) {
            this.currentLowerWordPointer = this.lowerPointer(this.MAX_WORDS);
        } else {
            this.currentLowerWordPointer = -1;
            int n = 0;
            while (n < this.wordList.size()) {
                if (((Word)this.wordList.get(n)).getWord().toLowerCase().startsWith(string)) {
                    this.currentLowerWordPointer = n;
                    break;
                }
                ++n;
            }
            if (this.currentLowerWordPointer == -1) {
                this.currentLowerWordPointer = 0;
                this.MAX_WORDS = 0;
            } else {
                this.currentHigherWordPointer = -1;
                int n2 = this.currentLowerWordPointer;
                while (n2 < this.wordList.size()) {
                    this.currentHigherWordPointer = n2;
                    if (!((Word)this.wordList.get(n2)).getWord().toLowerCase().startsWith(string)) break;
                    ++n2;
                }
                int n3 = this.currentHigherWordPointer - this.currentLowerWordPointer;
                if (this.MAX_WORDS <= 0 || n3 <= this.MAX_WORDS) {
                    this.MAX_WORDS = n3;
                }
            }
            this.maxWords.setText(this.MAX_WORDS + "");
        }
    }

    protected void resetMaxOptions() {
        try {
            int n = Integer.parseInt(this.maxOptions.getText());
            if (n < 0) {
                throw new Exception();
            }
            this.MAX_OPTIONS = n;
            this.resetRadioPanel();
            this.startSequence();
            this.check();
        }
        catch (Exception exception) {
            this.maxOptions.setText(this.MAX_OPTIONS + "");
        }
    }

    protected void resetMaxWords() {
        int n = 0;
        try {
            String string = this.maxWords.getText();
            int n2 = n = string.equals("*") ? this.wordList.size() : Integer.parseInt(string);
            if (n < 0 || n > this.wordList.size()) {
                throw new Exception();
            }
            this.MAX_WORDS = n;
            this.reset();
            this.startSequence();
        }
        catch (Exception exception) {
            n = this.MAX_WORDS = this.MAX_WORDS > this.wordList.size() ? this.wordList.size() : this.MAX_WORDS;
        }
        this.maxWords.setText(n + "");
    }

    protected void loadFile() {
        try {
            String string = this.fileName.getText();
            this.wordList = (ArrayList)new WordList(string).getList();
        }
        catch (Exception exception) {
            this.wordList = null;
            this.status.updateStatus("Error: " + exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    protected void startSequence() {
        this.textArea.setText("Score: " + this.correct + "/" + this.total + "\n\n");
        int n = 0;
        while (n < this.radioButton.length) {
            this.radioButtonGroup.remove(this.radioButton[n]);
            this.radioButton[n].setSelected(false);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.MAX_OPTIONS) {
            this.radioButtonGroup.add(this.radioButton[n2]);
            ++n2;
        }
        if (this.wordList == null || this.MAX_WORDS == 0) {
            return;
        }
        try {
            if (this.totalVisited == this.MAX_WORDS) {
                this.totalVisited = 0;
                this.visited = new boolean[this.wordList.size()];
            }
            do {
                this.currentHigherWordPointer = this.currentLowerWordPointer + this.higherPointer(this.MAX_WORDS);
            } while (this.visited[this.currentHigherWordPointer]);
            this.visited[this.currentHigherWordPointer] = true;
            ++this.totalVisited;
            this.textArea.append(((Word)this.wordList.get(this.currentHigherWordPointer)).getWord().toUpperCase() + "\n\n");
            this.currentMeaningList = new ArrayList();
            this.currentMeaningList.add(((Word)this.wordList.get(this.currentHigherWordPointer)).getMeaning());
            int n3 = 0;
            while (n3 < this.MAX_OPTIONS - 1) {
                this.currentMeaningList.add(((Word)this.wordList.get(this.higherPointer(this.wordList.size()))).getMeaning());
                ++n3;
            }
            Collections.shuffle(this.currentMeaningList);
            int n4 = 0;
            while (n4 < this.MAX_OPTIONS) {
                this.textArea.append("(" + (n4 + 1) + ") " + (String)this.currentMeaningList.get(n4) + "\n");
                ++n4;
            }
        }
        catch (Exception exception) {
            this.status.updateStatus("Error: " + exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    protected int lowerPointer(int n) {
        int n2 = this.wordList.size();
        if (n > n2) {
            return 0;
        }
        return (int)Math.floor(Math.random() * (double)(n2 - n));
    }

    protected int higherPointer(int n) {
        return (int)Math.floor(Math.random() * (double)n);
    }

    protected void check() {
        if (this.wordList == null) {
            return;
        }
        String string = ((Word)this.wordList.get(this.currentHigherWordPointer)).getMeaning();
        int n = 0;
        while (n < this.MAX_OPTIONS) {
            if (this.radioButton[n].isSelected() && ((String)this.currentMeaningList.get(n)).equalsIgnoreCase(string)) {
                this.status.updateStatus("CORRECT !!");
                ++this.correct;
                return;
            }
            ++n;
        }
        this.status.updateStatus("WRONG ... " + string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Next")) {
            this.startSequence();
            this.status.updateStatus("Words visited: " + this.totalVisited);
        } else if (actionEvent.getActionCommand().equals("Check")) {
            ++this.total;
            this.check();
        } else if (actionEvent.getActionCommand().equals("Reset")) {
            this.reset();
            this.startSequence();
            this.status.updateStatus("Words visited: " + this.totalVisited);
        } else if (actionEvent.getActionCommand().equals("File Name")) {
            this.loadFile();
            this.reset();
            this.resetMaxWords();
            this.startSequence();
            this.status.updateStatus("Words visited: " + this.totalVisited);
        } else if (actionEvent.getActionCommand().equals("Filter")) {
            this.reset();
            this.startSequence();
            this.status.updateStatus("Words visited: " + this.totalVisited);
        } else if (actionEvent.getActionCommand().equals("Max Options")) {
            this.resetMaxOptions();
            this.status.updateStatus("Words visited: " + this.totalVisited);
        } else if (actionEvent.getActionCommand().equals("Max Words")) {
            this.resetMaxWords();
            this.resetFilter();
            this.status.updateStatus("Words visited: " + this.totalVisited);
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        FlashCard flashCard = new FlashCard();
        JFrame jFrame = new JFrame("FlashCard (http://zwares.tripod.com)");
        jFrame.getContentPane().add(flashCard);
        jFrame.setSize(250, 350);
        jFrame.setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }
}

