/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

public class WordList
implements Serializable {
    private static final String DELIM = "::";
    private Collection wordlist = new ArrayList();

    public WordList(String string) throws Exception {
        this(new String[]{string});
    }

    public WordList(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            this.load(stringArray[n]);
            ++n;
        }
    }

    public void load(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, DELIM);
            if (stringTokenizer.countTokens() != 2) continue;
            this.wordlist.add(new Word(stringTokenizer.nextToken(), stringTokenizer.nextToken()));
        }
    }

    public Collection getList() {
        return this.wordlist;
    }

    public void print() {
        Iterator iterator = this.wordlist.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next().toString());
        }
    }

    public static void main(String[] stringArray) {
        try {
            WordList wordList = null;
            wordList = stringArray.length == 0 ? new WordList("words.txt") : new WordList(stringArray);
            wordList.print();
        }
        catch (Exception exception) {
            System.out.println("Failed to load file: " + exception);
        }
    }
}

